#include <stdio.h>
#include <string.h>

typedef struct
{
    int id;
    char boja[20];
    int kolicina;
} LegoKockica;

typedef struct
{
    char boja[20];
    int brRazlicitih;
    LegoKockica kockice[30];
} LegoKutija;

int UnosLegoKockica(char dat[30], LegoKockica legoKockice[])
{
    int i, n;
    FILE *f = fopen(dat, "r");

    fscanf(f, "%d", &n);
    for (i = 0; i < n; i++)
        fscanf(f, "%d%s%d", &legoKockice[i].id, legoKockice[i].boja, &legoKockice[i].kolicina);
    fclose(f);

    return n;
}

int UnosKutija(char dat[30], LegoKutija legoKutija[])
{
    int i, n = 0;
    char boja[20];
    FILE *f = fopen(dat, "r");

    while (fscanf(f, "%s", boja) == 1)
    {
        strcpy(legoKutija[n].boja, boja);
        legoKutija[n].brRazlicitih = 0;
        n++;
    }
    fclose(f);

    return n;
}

void IspisKutije(LegoKutija legoKutija)
{
    int i;
    char dat[30];

    strcpy(dat, legoKutija.boja);
    strcat(dat, ".txt");

    FILE *f = fopen(dat, "w");
    for (i = 0; i < legoKutija.brRazlicitih; i++)
        fprintf(f, "%d %s %d\n", legoKutija.kockice[i].id, legoKutija.kockice[i].boja, legoKutija.kockice[i].kolicina);
    fclose(f);
}

void UbaciLegoKockice(LegoKockica legoKockice[], int n, LegoKutija legoKutije[], int m)
{
    int i, j;

    for (i = 0; i < n; i++)
        for (j = 0; j < m; j++)
            if (!strcmp(legoKockice[i].boja, legoKutije[j].boja))
            {
                legoKutije[j].kockice[legoKutije[j].brRazlicitih] = legoKockice[i];
                legoKutije[j].brRazlicitih++;
            }
}

LegoKutija SortKutiju(LegoKutija legoKutija)
{
    int i, j;
    LegoKockica t;

    for (i = 0; i < legoKutija.brRazlicitih - 1; i++)
        for (j = i + 1; j < legoKutija.brRazlicitih; j++)
            if (legoKutija.kockice[i].kolicina < legoKutija.kockice[j].kolicina)
            {
                t = legoKutija.kockice[i];
                legoKutija.kockice[i] = legoKutija.kockice[j];
                legoKutija.kockice[j] = t;
            }

    return legoKutija;
}

int main()
{
    LegoKockica legoKockice[30];
    LegoKutija legoKutije[20];
    char datKutije[30], datKockice[30];
    int i, n, m;
    
    scanf("%s%s", datKockice, datKutije);
    n = UnosLegoKockica(datKockice, legoKockice);
    m = UnosKutija(datKutije, legoKutije);

    for (i = 0; i < n; i++)
        printf("%d %s %d\n", legoKockice[i].id, legoKockice[i].boja, legoKockice[i].kolicina);
    printf("------------------\n");
    for (i = 0; i < m; i++)
        printf("%s\n", legoKutije[i].boja);

    UbaciLegoKockice(legoKockice, n, legoKutije, m);

    for (i = 0; i < m; i++)
    {
        legoKutije[i] = SortKutiju(legoKutije[i]);
        IspisKutije(legoKutije[i]);
    }

    return 0;
}
